/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Setting {
    private static final HashMap<String, Setting> allSettingsByXmlPath = new HashMap();
    private static final HashMap<String, Setting> allSettingsByPrefPath = new HashMap();
    private final String xmlPath;
    private final Object factoryObj;
    private Object currentObj;
    private final Preferences prefs;
    private final String prefName;
    private final String prefPath;
    private boolean valid;
    private final String description;
    private final String location;
    private String[] trueMeaning;
    public static Comparator<Setting> SETTINGS_BY_PREF_NAME = new Comparator<Setting>(){

        @Override
        public int compare(Setting s1, Setting s2) {
            String n1 = s1.getPrefName();
            String n2 = s2.getPrefName();
            return n1.compareTo(n2);
        }
    };

    public Setting(String prefName, Pref.Group group, String xmlNode, String xmlName, String location, String description, Object factoryObj) {
        EDatabase.serverDatabase().checkChanging();
        if (xmlNode == null) {
            throw new NullPointerException();
        }
        if (xmlName == null) {
            xmlName = prefName;
        }
        this.xmlPath = xmlNode + xmlName;
        assert (!allSettingsByXmlPath.containsKey(this.xmlPath));
        this.factoryObj = factoryObj;
        this.currentObj = factoryObj;
        this.prefName = prefName;
        this.prefs = group.preferences;
        this.prefPath = this.prefs.absolutePath() + "/" + prefName;
        assert (!allSettingsByPrefPath.containsKey(this.prefPath));
        allSettingsByXmlPath.put(this.xmlPath, this);
        allSettingsByPrefPath.put(this.prefPath, this);
        assert (allSettingsByXmlPath.size() == allSettingsByPrefPath.size());
        this.valid = true;
        this.description = description;
        this.location = location;
        this.setCachedObjFromPreferences();
        ProjSettings.putValue(this);
    }

    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    public int getInt() {
        return (Integer)this.getValue();
    }

    public long getLong() {
        return (Long)this.getValue();
    }

    public double getDouble() {
        return (Double)this.getValue();
    }

    public String getString() {
        return (String)this.getValue();
    }

    public void set(Object v) {
        EDatabase.serverDatabase().checkChanging();
        if (this.getValue().equals(v)) {
            return;
        }
        if (v.getClass() != this.factoryObj.getClass()) {
            throw new ClassCastException();
        }
        this.currentObj = this.factoryObj.equals(v) ? this.factoryObj : v;
        this.saveToPreferences(v);
        this.setSideEffect();
    }

    protected void setSideEffect() {
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public String getPrefName() {
        return this.prefName;
    }

    public Object getValue() {
        return this.currentObj;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public void setValidOption(boolean valid) {
        this.valid = valid;
    }

    public boolean isValidOption() {
        return this.valid;
    }

    public void setTrueMeaning(String[] trueMeaning) {
        this.trueMeaning = trueMeaning;
    }

    public String[] getTrueMeaning() {
        return this.trueMeaning;
    }

    public Object getFactoryValue() {
        return this.factoryObj;
    }

    public double getDoubleFactoryValue() {
        return (Double)this.factoryObj;
    }

    public static Setting makeBooleanSetting(String name, Pref.Group group, String xmlNode, String xmlName, String location, String description, boolean factory) {
        Setting setting = Setting.getSetting(xmlNode + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeIntSetting(String name, Pref.Group group, String xmlNode, String xmlName, String location, String description, int factory) {
        Setting setting = Setting.getSetting(xmlNode + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeLongSetting(String name, Pref.Group group, String xmlNode, String xmlName, String location, String description, long factory) {
        Setting setting = Setting.getSetting(xmlNode + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeDoubleSetting(String name, Pref.Group group, String xmlNode, String xmlName, String location, String description, double factory) {
        Setting setting = Setting.getSetting(xmlNode + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting makeStringSetting(String name, Pref.Group group, String xmlNode, String xmlName, String location, String description, String factory) {
        Setting setting = Setting.getSetting(xmlNode + xmlName);
        if (setting != null) {
            return setting;
        }
        return new Setting(name, group, xmlNode, xmlName, location, description, factory);
    }

    public static Setting getSetting(String xmlPath) {
        return allSettingsByXmlPath.get(xmlPath);
    }

    public static Setting getSettingByPrefPath(String prefPath) {
        return allSettingsByPrefPath.get(prefPath);
    }

    public static Map<Setting, Object> reconcileSettings(Map<Setting, Object> projectSettings) {
        HashSet<Setting> markedSettings = new HashSet<Setting>();
        HashMap<Setting, Object> settingsToReconcile = new HashMap<Setting, Object>();
        for (Map.Entry<Setting, Object> e : projectSettings.entrySet()) {
            Setting setting = e.getKey();
            Object value = e.getValue();
            markedSettings.add(setting);
            if (DBMath.objectsReallyEqual(value, setting.getValue()) || !setting.isValidOption()) continue;
            settingsToReconcile.put(setting, value);
        }
        for (Setting setting : allSettingsByXmlPath.values()) {
            if (markedSettings.contains(setting) || DBMath.objectsReallyEqual(setting.getValue(), setting.getFactoryValue()) || !setting.isValidOption()) continue;
            settingsToReconcile.put(setting, null);
        }
        return settingsToReconcile;
    }

    public static void finishSettingReconcilation(Map<Setting, Object> settingsToReconcile) {
        Pref.delayPrefFlushing();
        for (Map.Entry<Setting, Object> e : settingsToReconcile.entrySet()) {
            Setting setting = e.getKey();
            Object obj = e.getValue();
            if (obj == null) {
                obj = setting.factoryObj;
            }
            if (obj.getClass() != setting.factoryObj.getClass()) {
                if (obj instanceof Integer && setting.factoryObj instanceof Boolean) {
                    obj = (Integer)obj != 0;
                } else {
                    if (!(obj instanceof Float) || !(setting.factoryObj instanceof Double)) continue;
                    obj = ((Float)obj).doubleValue();
                }
            }
            setting.set(obj);
            System.out.println("Project Setting " + setting.xmlPath + " changed to " + obj);
        }
        Pref.resumePrefFlushing();
    }

    static void saveAllSettingsToPreferences() {
        for (Setting setting : allSettingsByXmlPath.values()) {
            Object value = setting.getValue();
            setting.saveToPreferences(value);
        }
    }

    private void saveToPreferences(Object v) {
        assert (v.getClass() == this.factoryObj.getClass());
        if (v.equals(this.factoryObj)) {
            this.prefs.remove(this.prefName);
            return;
        }
        if (v instanceof Boolean) {
            this.prefs.putBoolean(this.prefName, (Boolean)v);
        } else if (v instanceof Integer) {
            this.prefs.putInt(this.prefName, (Integer)v);
        } else if (v instanceof Long) {
            this.prefs.putLong(this.prefName, (Long)v);
        } else if (v instanceof Double) {
            this.prefs.putDouble(this.prefName, (Double)v);
        } else if (v instanceof String) {
            this.prefs.put(this.prefName, (String)v);
        } else assert (false);
    }

    private void setCachedObjFromPreferences() {
        Object cachedObj = null;
        if (this.factoryObj instanceof Boolean) {
            cachedObj = this.prefs.getBoolean(this.prefName, (Boolean)this.factoryObj);
        } else if (this.factoryObj instanceof Integer) {
            cachedObj = this.prefs.getInt(this.prefName, (Integer)this.factoryObj);
        } else if (this.factoryObj instanceof Long) {
            cachedObj = this.prefs.getLong(this.prefName, (Long)this.factoryObj);
        } else if (this.factoryObj instanceof Double) {
            cachedObj = this.prefs.getDouble(this.prefName, (Double)this.factoryObj);
        } else if (this.factoryObj instanceof String) {
            cachedObj = this.prefs.get(this.prefName, (String)this.factoryObj);
        }
        assert (cachedObj != null);
        this.currentObj = cachedObj;
    }

    public static void implementSettingChanges(SettingChangeBatch batch) {
        for (Map.Entry<String, Object> e : batch.changesForSettings.entrySet()) {
            String xmlPath = e.getKey();
            Object newValue = e.getValue();
            Setting setting = Setting.getSetting(xmlPath);
            setting.set(newValue);
        }
    }

    public static Map<Setting, Object> resetContext() {
        HashMap<Setting, Object> savedContext = new HashMap<Setting, Object>();
        for (Setting setting : allSettingsByXmlPath.values()) {
            savedContext.put(setting, setting.getValue());
            setting.set(setting.getFactoryValue());
        }
        return savedContext;
    }

    public static void restoreContext(Map<Setting, Object> savedContext) {
        for (Map.Entry<Setting, Object> e : savedContext.entrySet()) {
            Setting setting = e.getKey();
            setting.set(e.getValue());
        }
    }

    public static Collection<Setting> getSettings() {
        return allSettingsByXmlPath.values();
    }

    static void printAllSettings(PrintStream out) {
        TreeMap<String, Setting> sortedSettings = new TreeMap<String, Setting>();
        for (Setting setting : allSettingsByXmlPath.values()) {
            sortedSettings.put(setting.xmlPath, setting);
        }
        out.println("PROJECT SETTINGS");
        int i = 0;
        for (Setting setting : sortedSettings.values()) {
            out.println(i++ + "\t" + setting.xmlPath + " " + setting.getValue());
        }
    }

    public static class SettingChangeBatch
    implements Serializable {
        public HashMap<String, Object> changesForSettings = new HashMap();

        public void add(Setting setting, Object newValue) {
            this.changesForSettings.put(setting.xmlPath, newValue);
        }
    }
}

