/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.cmosPLA;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.cmosPLA.IO;
import com.sun.electric.tool.generator.cmosPLA.PLA;

public class PGrid {
    private PLA pla;

    PGrid(PLA pla) {
        this.pla = pla;
    }

    Cell pmosGrid(Library library, String fileName, String cellName) {
        int y = 0;
        int x = 3;
        int xOffset = 10;
        int yOffset = 10;
        int yMOffset = 10;
        Cell cell = Cell.makeInstance(library, cellName);
        IO perFile = new IO();
        if (!perFile.readHeader(fileName)) {
            System.out.println("Error reading height and width");
            return null;
        }
        int width = perFile.getWidth();
        int height = perFile.getHeight();
        int widthIn = perFile.getWidthIn();
        int heightIn = perFile.getHeightIn();
        cell.newVar("PLA_data_cols", (Object)new Integer(widthIn));
        cell.newVar("PLA_access_rows", (Object)new Integer(heightIn));
        cell.newVar("PLA_cols", (Object)new Integer(width));
        cell.newVar("PLA_rows", (Object)new Integer(height));
        if (this.pmosInitColumns(width, x, y, xOffset, cell)) {
            return null;
        }
        if (this.pmosInitRows(heightIn, x, y, yOffset, yMOffset, cell)) {
            return null;
        }
        y = 3 - yOffset;
        x = xOffset + 4;
        int row = 0;
        int readRows = 0;
        while (readRows < heightIn) {
            int[] row1 = null;
            int[] row2 = null;
            if (readRows < heightIn) {
                row1 = perFile.readRow();
                if (row1 == null) {
                    return null;
                }
                ++readRows;
            }
            if (readRows < heightIn) {
                row2 = perFile.readRow();
                if (row2 == null) {
                    return null;
                }
                ++readRows;
            }
            for (int i = 0; i < width; ++i) {
                if (i % 5 == 0 && i != 0) {
                    if (!this.pwrStrap(i, xOffset * i + 3, y, cell)) continue;
                    return null;
                }
                if (row1[i] == 1 && row1[0] != -1 && this.pmosMakeOne(i, i * xOffset + 6, y, 0, row, cell)) {
                    return null;
                }
                if (row2[i] != 1 || row2[0] == -1 || !this.pmosMakeOne(i, i * xOffset + 6, y - yMOffset, 2, row, cell)) continue;
                return null;
            }
            if (this.pmosCompleteRow(row, xOffset * width + 0, y, cell)) {
                return null;
            }
            if (readRows % 4 == 0) {
                y -= yOffset;
            }
            ++row;
            y -= 2 * yOffset;
        }
        x = 3;
        y = readRows % 4 == 0 ? (y += 2 * yOffset - 3) : (y += yOffset - 3);
        if (this.pmosFinishColumns(width, x, y, xOffset, cell)) {
            return null;
        }
        perFile.done();
        return cell;
    }

    private boolean pmosInitColumns(int width, int x, int y, int xOffset, Cell arrayCell) {
        int pwrCnt = 0;
        for (int i = 0; i < width; ++i) {
            String name;
            this.pla.columnList[i].lastitem = this.pla.columnList[i].firstItem = new PLA.UCItem();
            if (i % 5 == 0) {
                name = "PWR" + pwrCnt + ".m-1.n";
                this.pla.columnList[i].firstItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 14.0, this.pla.msBut);
                if (this.pla.columnList[i].firstItem.nodeInst == null) {
                    return true;
                }
                ++pwrCnt;
            } else {
                name = "DATA" + (i - pwrCnt) + ".m-1.n";
                this.pla.columnList[i].firstItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 4.0, this.pla.m1Pin);
                if (this.pla.columnList[i].firstItem.nodeInst == null) {
                    return true;
                }
            }
            PortProto pp = this.pla.columnList[i].firstItem.nodeInst.getProto().getPort(0);
            PortInst pi = this.pla.columnList[i].firstItem.nodeInst.findPortInstFromProto(pp);
            Export.newInstance(arrayCell, pi, name);
        }
        return false;
    }

    private boolean pmosInitRows(int heightIn, int x, int y, int yOffset, int yMOffset, Cell arrayCell) {
        int limit = heightIn / 2 + heightIn % 2;
        for (int i = 0; i < limit; ++i) {
            PLA.UCItem newItem = new PLA.UCItem();
            if (i % 2 == 0 && i != 0) {
                y -= yOffset;
            }
            newItem.nodeInst = this.pla.makePin(arrayCell, x, y - yMOffset + 10, 14.0, this.pla.msBut);
            if (newItem.nodeInst == null) {
                return true;
            }
            PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
            PortProto lastColPort = this.pla.columnList[0].lastitem.nodeInst.getProto().getPort(0);
            this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[0].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
            this.pla.columnList[0].lastitem = this.pla.columnList[0].lastitem.bottomItem = newItem;
            this.pla.rowList[i][0].lastitem = this.pla.rowList[i][0].firstItem = new PLA.UCItem();
            this.pla.rowList[i][2].lastitem = this.pla.rowList[i][2].firstItem = new PLA.UCItem();
            this.pla.rowList[i][0].firstItem.nodeInst = this.pla.makePin(arrayCell, x - 7, y - 5, 6.0, this.pla.mpCon);
            if (this.pla.rowList[i][0].firstItem.nodeInst == null) {
                return true;
            }
            this.pla.rowList[i][2].firstItem.nodeInst = this.pla.makePin(arrayCell, x - 7, y - 15, 6.0, this.pla.mpCon);
            if (this.pla.rowList[i][2].firstItem.nodeInst == null) {
                return true;
            }
            y -= 2 * yOffset;
        }
        return false;
    }

    private boolean pwrStrap(int i, int x, int y, Cell arrayCell) {
        PLA.UCItem newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y + 7, 14.0, this.pla.msBut);
        if (newItem.nodeInst == null) {
            return true;
        }
        PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
        PortProto lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = newItem;
        return false;
    }

    private boolean pmosMakeOne(int i, int x, int y, int rowPos, int row, Cell arrayCell) {
        NodeInst ni = this.pla.makeInstance(arrayCell, this.pla.pmosOne, x, y, false);
        if (ni == null) {
            return true;
        }
        PortProto nodeColPort = ni.getProto().findPortProto("IN.m-1.n");
        PortProto lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto() != this.pla.pmosOne ? this.pla.columnList[i].firstItem.nodeInst.getProto().getPort(0) : this.pla.columnList[i].lastitem.nodeInst.getProto().findPortProto("OUT.m-1.s");
        this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, ni, nodeColPort, arrayCell);
        lastColPort = this.pla.rowList[row][rowPos].lastitem.nodeInst.getProto() != this.pla.pmosOne ? this.pla.rowList[row][rowPos].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][rowPos].lastitem.nodeInst.getProto().findPortProto("GATE.p.e");
        nodeColPort = ni.getProto().findPortProto("GATE.p.w");
        this.pla.makeWire(this.pla.pArc, 0.0, this.pla.rowList[row][rowPos].lastitem.nodeInst, lastColPort, ni, nodeColPort, arrayCell);
        this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = new PLA.UCItem();
        this.pla.columnList[i].lastitem.nodeInst = ni;
        this.pla.rowList[row][rowPos].lastitem = this.pla.rowList[row][rowPos].lastitem.rightItem = this.pla.columnList[i].lastitem;
        return false;
    }

    private boolean pmosCompleteRow(int row, int x, int y, Cell arrayCell) {
        PLA.UCItem newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y + 2, 6.0, this.pla.mpCon);
        if (newItem.nodeInst == null) {
            return true;
        }
        PortProto lastColPort = this.pla.rowList[row][0].lastitem.nodeInst.getProto() != this.pla.pmosOne ? this.pla.rowList[row][0].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][0].lastitem.nodeInst.getProto().findPortProto("GATE.p.e");
        PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.pArc, 0.0, this.pla.rowList[row][0].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.rowList[row][0].lastitem = newItem;
        PortProto pp = this.pla.rowList[row][0].firstItem.nodeInst.getProto().getPort(0);
        PortInst pi = this.pla.rowList[row][0].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + row * 2 + ".m-1.w");
        pp = this.pla.rowList[row][0].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][0].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + row * 2 + ".m-1.e");
        pp = this.pla.rowList[row][0].firstItem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][0].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + row * 2 + ".p.w");
        pp = this.pla.rowList[row][0].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][0].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + row * 2 + ".p.e");
        newItem = new PLA.UCItem();
        newItem.nodeInst = this.pla.makePin(arrayCell, x, y - 8, 6.0, this.pla.mpCon);
        if (newItem.nodeInst == null) {
            return true;
        }
        lastColPort = this.pla.rowList[row][2].lastitem.nodeInst.getProto() != this.pla.pmosOne ? this.pla.rowList[row][2].lastitem.nodeInst.getProto().getPort(0) : this.pla.rowList[row][2].lastitem.nodeInst.getProto().findPortProto("GATE.p.e");
        nodeColPort = newItem.nodeInst.getProto().getPort(0);
        this.pla.makeWire(this.pla.pArc, 0.0, this.pla.rowList[row][2].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
        this.pla.rowList[row][2].lastitem = newItem;
        pp = this.pla.rowList[row][2].firstItem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".m-1.w");
        pp = this.pla.rowList[row][2].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".m-1.e");
        pp = this.pla.rowList[row][2].firstItem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].firstItem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".p1.w");
        pp = this.pla.rowList[row][2].lastitem.nodeInst.getProto().getPort(0);
        pi = this.pla.rowList[row][2].lastitem.nodeInst.findPortInstFromProto(pp);
        Export.newInstance(arrayCell, pi, "ACCESS" + (row * 2 + 1) + ".p.e");
        return false;
    }

    private boolean pmosFinishColumns(int width, int x, int y, int xOffset, Cell arrayCell) {
        int pwrCnt = 0;
        for (int i = 0; i < width; ++i) {
            PortProto lastColPort;
            String name;
            PLA.UCItem newItem = new PLA.UCItem();
            if (i % 5 == 0) {
                name = "PWR" + pwrCnt + ".m-1.s";
                newItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 14.0, this.pla.msBut);
                if (newItem.nodeInst == null) {
                    return true;
                }
                lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0);
                ++pwrCnt;
            } else {
                name = "DATA" + (i - pwrCnt) + ".m-1.s";
                newItem.nodeInst = this.pla.makePin(arrayCell, xOffset * i + x, y, 4.0, this.pla.m1Pin);
                if (newItem.nodeInst == null) {
                    return true;
                }
                lastColPort = this.pla.columnList[i].lastitem.nodeInst.getProto() != this.pla.pmosOne ? this.pla.columnList[i].lastitem.nodeInst.getProto().getPort(0) : this.pla.columnList[i].lastitem.nodeInst.getProto().findPortProto("OUT.m-1.s");
            }
            PortProto nodeColPort = newItem.nodeInst.getProto().getPort(0);
            this.pla.makeWire(this.pla.m1Arc, 4.0, this.pla.columnList[i].lastitem.nodeInst, lastColPort, newItem.nodeInst, nodeColPort, arrayCell);
            this.pla.columnList[i].lastitem = this.pla.columnList[i].lastitem.bottomItem = newItem;
            PortInst pi = newItem.nodeInst.findPortInstFromProto(newItem.nodeInst.getProto().getPort(0));
            Export.newInstance(arrayCell, pi, name);
        }
        return false;
    }
}

