/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.sctiming.Arc;
import com.sun.electric.tool.simulation.sctiming.LibData;
import com.sun.electric.tool.simulation.sctiming.PinEdge;
import com.sun.electric.tool.simulation.sctiming.SCSettings;
import com.sun.electric.tool.simulation.sctiming.SCTiming;
import com.sun.electric.tool.simulation.sctiming.SCTimingException;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SCRunBase {
    private static Pattern cellsize1 = Pattern.compile(".*?_([0-9.]+)x");
    private static Pattern cellsize2 = Pattern.compile(".*?_x([0-9.]+)");
    private static double lowerBound = 1.0E-5;
    private static int upperBound = 310;
    private static int numSizes = 8;

    public boolean characterizeCells(SCSettings settings, DelayType delayType) {
        Library lib = Library.getCurrent();
        if (lib == null) {
            System.out.println("No current library to characterize");
            return false;
        }
        File libraryDir = null;
        libraryDir = lib.getLibFile() != null ? TextUtils.getFile(lib.getLibFile()).getParentFile() : new File(User.getWorkingDirectory());
        File outputDir = new File(libraryDir, lib.getName() + "_chardata" + delayType.toString());
        if (!outputDir.exists() && !outputDir.mkdir()) {
            System.out.println("Cannot make char data directory " + outputDir.getPath());
            return false;
        }
        System.out.println("Set output directory to " + outputDir.getPath());
        settings.setLibrary(lib.getName());
        LibData.Group library = settings.getLibrary();
        File libertyFile = new File(libraryDir, lib.getName() + "." + delayType.toString() + ".lib");
        if (libertyFile.exists()) {
            LibData libdata = this.parseExisting(libertyFile);
            if (libdata != null) {
                System.out.println("Found existing liberty file " + libertyFile.getPath());
                System.out.println("  Using settings in existing liberty file");
                System.out.println("  Characterizing new cells only");
                settings.getSettingsFromLibData(libdata);
                library = libdata.getLibrary();
            } else {
                System.out.println("Error reading existing liberty file");
                return false;
            }
        }
        HashMap<String, String> extractedCells = new HashMap<String, String>();
        File extractedNetlist = new File(User.getWorkingDirectory(), lib.getName() + ".sp");
        if (extractedNetlist.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(extractedNetlist));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String[] parts;
                    if (!line.startsWith(".SUBCKT") || (parts = line.split("\\s+")).length < 2) continue;
                    extractedCells.put(parts[1], parts[1]);
                }
                in.close();
            }
            catch (IOException ee) {
                System.out.println(ee.getMessage());
            }
        }
        boolean warned = false;
        ArrayList<String> messages = new ArrayList<String>();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (c.getView() != View.LAYOUT || c != c.getNewestVersion()) continue;
            String verilogCellName = Spice.getSafeNetName(c.getName(), SimulationTool.SpiceEngine.SPICE_ENGINE_H);
            List<LibData.Group> existing = library.getGroups("cell", verilogCellName);
            if (existing.size() > 0) {
                messages.add("Info: Skipped cell " + c.getName() + ", already exists in liberty file data");
                continue;
            }
            SCTiming timing = SCRunBase.getSCTimingSetup(c, settings);
            String cname = c.getName();
            if (timing == null) {
                messages.add("Warning: Skipping " + cname + ": Unable to find timing arcs");
                continue;
            }
            File cellDir = new File(outputDir, c.getName());
            if (!cellDir.exists() && !cellDir.mkdir()) {
                messages.add("Error: Cannot make cell char data directory " + cellDir.getPath() + "; skipping cell " + cname);
                continue;
            }
            File outputFile = new File(cellDir, c.getName() + ".sp");
            String cellName = Spice.getSafeNetName(c.getName(), SimulationTool.SpiceEngine.SPICE_ENGINE_H);
            if (extractedCells.containsKey(cellName)) {
                try {
                    PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
                    writer.println("* Characterization file for Cell " + cellName);
                    writer.println("*");
                    writer.println(".include '" + extractedNetlist.getAbsolutePath() + "'");
                    writer.println(".include '" + settings.commonHeaderFile + "'");
                    writer.println();
                    writer.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
                timing.setTopCellName(cellName);
            } else {
                Spice.SpicePreferences sp2 = new Spice.SpicePreferences(true, false);
                sp2.writeSubcktTopCell = true;
                sp2.writeTopCellInstance = false;
                sp2.writeTransSizeInLambda = true;
                sp2.writeEmptySubckts = false;
                sp2.cdlIgnoreResistors = false;
                sp2.useCellParameters = true;
                sp2.parasiticsLevel = SimulationTool.SpiceParasitics.RC_CONSERVATIVE;
                sp2.writeFinalDotEnd = false;
                sp2.parasiticsUseExemptedNetsFile = false;
                sp2.parasiticsExtractsR = true;
                sp2.parasiticsExtractsC = true;
                if (settings.commonHeaderFile.length() > 0) {
                    sp2.headerCardInfo = settings.commonHeaderFile;
                }
                sp2.doOutput(c, VarContext.globalContext, outputFile.getPath());
                timing.setTopCellName(c.getName());
            }
            timing.setOutputDir(cellDir.getPath());
            timing.setTopCell(c);
            timing.setTopCellNameLiberty(verilogCellName);
            timing.setInputFile(outputFile.getPath());
            try {
                timing.characterize_(delayType);
            }
            catch (SCTimingException e) {
                messages.add("Error: Failed to characterize cell " + c.describe(false) + ": " + e.getMessage());
                continue;
            }
            timing.getCellLibData(library);
            List<LibData.Group> list2 = library.getGroups("cell", verilogCellName);
            ERectangle rect = c.getBounds();
            double scale = c.getTechnology().getScale() / 1000.0;
            double area = rect.getWidth() * rect.getHeight() * scale * scale;
            for (LibData.Group g : list2) {
                g.putAttribute("area", area);
            }
        }
        System.out.println("\nCharacterization Complete\n");
        for (String message : messages) {
            System.out.println(message);
        }
        if (libertyFile.exists()) {
            File temp = new File(libertyFile.getPath());
            File backup = new File(libertyFile.getParent(), libertyFile.getName() + ".old");
            System.out.println("Renaming existing liberty file to " + backup.getName());
            if (!temp.renameTo(backup)) {
                System.out.println("Warning, unable to rename " + libertyFile.getName() + " to " + backup.getName());
            }
        }
        LibData libData = new LibData();
        libData.setLibrary(library);
        libData.write(libertyFile.getPath());
        System.out.println("Wrote liberty file to " + libertyFile.getPath());
        return true;
    }

    protected LibData parseExisting(File libertyFile) {
        return null;
    }

    public static SCTiming getSCTimingSetup(Cell cell, SCSettings settings) {
        SCTiming timing = null;
        Iterator<Cell> itc = cell.getCellGroup().getCells();
        while (itc.hasNext()) {
            Cell acell = itc.next();
            if (acell.getView() != View.DOC || acell != acell.getNewestVersion()) continue;
            timing = SCRunBase.getSetupFromScript(acell.getTextViewContents(), settings);
            break;
        }
        if (timing == null) {
            String cname = cell.getName().toLowerCase();
            for (GateType type : GateType.values()) {
                if (!cname.matches(type.toString().toLowerCase() + "_x[0-9.]+")) continue;
                String size2 = cname.substring(cname.lastIndexOf("x") + 1, cname.length());
                double xsize = Double.parseDouble(size2);
                timing = SCRunBase.getSCTimingSetup(type, settings, xsize);
                break;
            }
        }
        return timing;
    }

    public static double getCellSize(String cellname) {
        String s = null;
        Matcher m1 = cellsize1.matcher(cellname);
        if (m1.matches()) {
            s = m1.group(1);
        } else {
            Matcher m2 = cellsize2.matcher(cellname);
            if (m2.matches()) {
                s = m2.group(1);
            }
        }
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                return 1.0;
            }
        }
        return 1.0;
    }

    public static SCTiming getSetupFromScript(String[] script, SCSettings settings) {
        EvalJavaBsh bsh = new EvalJavaBsh();
        bsh.doEvalLine("import com.sun.electric.tool.simulation.sctiming.*;");
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        bsh.setVariable("timing", timing);
        bsh.setVariable("settings", settings);
        boolean run2 = false;
        boolean scriptFound = false;
        for (String line : script) {
            if (line.toLowerCase().startsWith("--start characterization script")) {
                run2 = true;
                scriptFound = true;
                continue;
            }
            if (line.toLowerCase().startsWith("--end characterization script")) {
                run2 = false;
                continue;
            }
            if (!run2) continue;
            bsh.doEvalLine(line);
        }
        Object t = bsh.getVariable("timing");
        if (scriptFound && t instanceof SCTiming) {
            return (SCTiming)t;
        }
        return null;
    }

    public static SCTiming getSCTimingSetup(GateType type, SCSettings settings, double xsize) {
        switch (type) {
            case INV: {
                return SCRunBase.getSetupInv(settings, xsize);
            }
            case INVHT: {
                return SCRunBase.getSetupInv(settings, xsize);
            }
            case INVLT: {
                return SCRunBase.getSetupInv(settings, xsize);
            }
            case INVCLK: {
                return SCRunBase.getSetupInv(settings, xsize);
            }
            case NAND2: {
                return SCRunBase.getSetupNand2(settings, xsize);
            }
            case NAND2EN: {
                return SCRunBase.getSetupNand2en(settings, xsize);
            }
            case NAND2CLKEN: {
                return SCRunBase.getSetupNand2en(settings, xsize);
            }
            case NAND3: {
                return SCRunBase.getSetupNand3(settings, xsize);
            }
            case NOR2: {
                return SCRunBase.getSetupNor2(settings, xsize);
            }
        }
        return null;
    }

    public static SCTiming getSetupInv(SCSettings settings, double xsize) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionCombinational("out", "!in");
        String outputLoads = SCRunBase.getLoadSweep(xsize);
        String buffers = SCRunBase.getInputBufferSweep(xsize);
        Arc arc = new Arc();
        arc.setInputTransition("in", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("in", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        return timing;
    }

    public static SCTiming getSetupNand2(SCSettings settings, double xsize) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionCombinational("out", "!(ina * inb)");
        String outputLoads = SCRunBase.getLoadSweep(xsize);
        String buffers = SCRunBase.getInputBufferSweep(xsize);
        Arc arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        return timing;
    }

    public static SCTiming getSetupNand2en(SCSettings settings, double xsize) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionCombinational("out", "!(ina * inb)");
        String outputLoads = SCRunBase.getLoadSweep(xsize);
        String buffers = SCRunBase.getInputBufferSweep(xsize);
        Arc arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        return timing;
    }

    public static SCTiming getSetupNand3(SCSettings settings, double xsize) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionCombinational("out", "!(ina * inb * inc)");
        String outputLoads = SCRunBase.getLoadSweep(xsize);
        String buffers = SCRunBase.getInputBufferSweep(xsize);
        Arc arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.addStableInput("inc", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.addStableInput("inc", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.addStableInput("inc", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.addStableInput("inc", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inc", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inc", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("ina", PinEdge.Transition.STABLE1);
        arc.addStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        return timing;
    }

    public static SCTiming getSetupNor2(SCSettings settings, double xsize) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionCombinational("out", "!(ina + inb)");
        String outputLoads = SCRunBase.getLoadSweep(xsize);
        String buffers = SCRunBase.getInputBufferSweep(xsize);
        Arc arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("inb", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("inb", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addStableInput("ina", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addStableInput("ina", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        return timing;
    }

    public static SCTiming getSetupXor2(SCSettings settings, double xsize) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionCombinational("out", "ina ^ inb");
        String outputLoads = SCRunBase.getLoadSweep(xsize);
        String buffers = SCRunBase.getInputBufferSweep(xsize);
        Arc arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addDependentStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addDependentStableInput("inb", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addDependentStableInput("inb", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("ina", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addDependentStableInput("inb", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addDependentStableInput("ina", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addDependentStableInput("ina", PinEdge.Transition.STABLE1);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.RISE);
        arc.setOutputTransition("out", PinEdge.Transition.RISE);
        arc.addDependentStableInput("ina", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("inb", PinEdge.Transition.FALL);
        arc.setOutputTransition("out", PinEdge.Transition.FALL);
        arc.addDependentStableInput("ina", PinEdge.Transition.STABLE0);
        arc.setOutputLoadSweep(outputLoads);
        arc.setInputBufferSweep(buffers);
        timing.addTimingArc(arc);
        return timing;
    }

    public static String getLoadSweep(double xsize) {
        double minStepup = 0.5;
        double maxStepup = 12.0;
        double minSize = xsize * minStepup;
        double maxSize = xsize * maxStepup;
        double stepX = (maxSize - minSize) / (double)numSizes;
        double su = Math.pow(maxStepup / minStepup, 1.0 / (double)(numSizes - 1));
        StringBuffer loads = new StringBuffer();
        for (int i = 0; i < numSizes; ++i) {
            double size2 = xsize * minStepup * Math.pow(su, i);
            if (size2 < lowerBound || size2 > (double)upperBound) continue;
            loads.append(TextUtils.formatDouble(size2, 2) + " ");
        }
        return loads.toString().trim();
    }

    public static String getInputBufferSweep(double xsize) {
        double minStepup = 0.08333333333333333;
        double maxStepup = 2.0;
        double su = Math.pow(maxStepup / minStepup, 1.0 / (double)(numSizes - 1));
        StringBuffer loads = new StringBuffer();
        for (int i = numSizes - 1; i >= 0; --i) {
            double size2 = xsize * minStepup * Math.pow(su, i);
            if ((size2 /= 2.0) < lowerBound || size2 > (double)upperBound) continue;
            loads.append(TextUtils.formatDouble(size2, 2) + " ");
        }
        return loads.toString().trim();
    }

    public static SCTiming getSetupFlopDDR(SCSettings settings) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionFlipFlop("Q", "QB", "D", "clkt");
        Arc arc = new Arc();
        arc.setInputTransition("D", PinEdge.Transition.RISE);
        arc.setOutputTransition("Q", PinEdge.Transition.RISE);
        arc.setClkTransition("clkt", PinEdge.Transition.RISE);
        arc.setClkFalseTransition("clkf", PinEdge.Transition.FALL);
        arc.addDUTInitialCondition("topnode2", settings.vdd);
        arc.addDUTInitialCondition("topnode1", 0.0);
        arc.addDUTInitialCondition("botnode2", settings.vdd);
        arc.addDUTInitialCondition("botnode1", 0.0);
        arc.setInputTransition("clr", PinEdge.Transition.STABLE0);
        arc.setInputTransition("init", PinEdge.Transition.STABLE0);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("D", PinEdge.Transition.FALL);
        arc.setOutputTransition("Q", PinEdge.Transition.FALL);
        arc.setClkTransition("clkt", PinEdge.Transition.RISE);
        arc.setClkFalseTransition("clkf", PinEdge.Transition.FALL);
        arc.addDUTInitialCondition("topnode2", 0.0);
        arc.addDUTInitialCondition("topnode1", settings.vdd);
        arc.addDUTInitialCondition("botnode2", 0.0);
        arc.addDUTInitialCondition("botnode1", settings.vdd);
        arc.setInputTransition("clr", PinEdge.Transition.STABLE0);
        arc.setInputTransition("init", PinEdge.Transition.STABLE0);
        timing.addTimingArc(arc);
        return timing;
    }

    public static SCTiming getSetupFlopSDR(SCSettings settings) {
        SCTiming timing = new SCTiming();
        timing.setSettings(settings);
        timing.setFunctionFlipFlop("Q", "QB", "D", "clkt");
        Arc arc = new Arc();
        arc.setInputTransition("D", PinEdge.Transition.RISE);
        arc.setOutputTransition("Q", PinEdge.Transition.RISE);
        arc.setClkTransition("clkt", PinEdge.Transition.RISE);
        arc.setClkFalseTransition("clkf", PinEdge.Transition.FALL);
        timing.addTimingArc(arc);
        arc = new Arc();
        arc.setInputTransition("D", PinEdge.Transition.FALL);
        arc.setOutputTransition("Q", PinEdge.Transition.FALL);
        arc.setClkTransition("clkt", PinEdge.Transition.RISE);
        arc.setClkFalseTransition("clkf", PinEdge.Transition.FALL);
        timing.addTimingArc(arc);
        return timing;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DelayType {
        MAX,
        MIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GateType {
        INV,
        INVHT,
        INVLT,
        INVCLK,
        NAND2EN,
        NAND2CLKEN,
        NAND2,
        NAND3,
        NOR2,
        XOR2;

    }
}

