/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Range$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class FlatHashTable$class {
    public static int loadFactor(FlatHashTable $this) {
        return 450;
    }

    public static final int loadFactorDenum(FlatHashTable $this) {
        return 1000;
    }

    public static int initialSize(FlatHashTable $this) {
        return 16;
    }

    private static int capacity(FlatHashTable $this, int expectedSize) {
        int n;
        if (expectedSize == 0) {
            n = 1;
        } else {
            int c0 = expectedSize - 1;
            c0 |= c0 >>> 1;
            c0 |= c0 >>> 2;
            c0 |= c0 >>> 4;
            c0 |= c0 >>> 8;
            c0 |= c0 >>> 16;
            n = c0 + 1;
        }
        return n;
    }

    private static int initialCapacity(FlatHashTable $this) {
        return FlatHashTable$class.capacity($this, $this.initialSize());
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size2 = in.readInt();
        Predef$.MODULE$.assert(size2 >= 0);
        $this.table_$eq(new Object[FlatHashTable$class.capacity($this, size2 * $this.loadFactorDenum() / $this._loadFactor())]);
        Object[] objectArray = $this.table();
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, new ArrayOps.ofRef<Object>(objectArray).size()));
        for (int index2 = 0; index2 < size2; ++index2) {
            Object elem2 = in.readObject();
            f.apply(elem2);
            $this.addEntry(elem2);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out$1) {
        out$1.defaultWriteObject();
        out$1.writeInt($this._loadFactor());
        out$1.writeInt($this.tableSize());
        $this.iterator().foreach(new FlatHashTable$.anonfun.serializeTo.1($this, out$1));
    }

    public static Option findEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null && !(entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry == null ? None$.MODULE$ : new Some<Object>(entry);
    }

    public static boolean containsEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null && !(entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2)))))) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return entry != null;
    }

    public static boolean addEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (true) {
            if (entry == null) {
                $this.table()[h] = elem2;
                $this.tableSize_$eq($this.tableSize() + 1);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return true;
            }
            if (entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2))))) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static Option removeEntry(FlatHashTable $this, Object elem2) {
        int h = $this.index($this.elemHashCode(elem2));
        Object entry = $this.table()[h];
        while (entry != null) {
            if (entry == elem2 ? true : (entry == null ? false : (entry instanceof Number ? BoxesRunTime.equalsNumObject((Number)entry, elem2) : (entry instanceof Character ? BoxesRunTime.equalsCharObject((Character)entry, elem2) : entry.equals(elem2))))) {
                int h0 = h;
                int h1 = (h + 1) % $this.table().length;
                while (true) {
                    if ($this.table()[h1] == null) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        return new Some<Object>(entry);
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return None$.MODULE$;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new FlatHashTable$.anon.1($this);
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            $this.addEntry(entry);
        }
    }

    private static void checkConsistent(FlatHashTable $this) {
        int n = $this.table().length;
        int n2 = 0;
        new Range$.anon.2(n2, n).foreach$mVc$sp((Function1<Integer, Object>)new FlatHashTable$.anonfun.checkConsistent.1($this));
    }

    public static int elemHashCode(FlatHashTable $this, Object elem2) {
        return elem2 == null ? 0 : elem2.hashCode();
    }

    public static final int improve(FlatHashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    private static int newThreshold(FlatHashTable $this, int size2) {
        boolean bl;
        int lf = $this._loadFactor();
        boolean bl2 = bl = lf < $this.loadFactorDenum() / 2;
        if (bl) {
            return (int)((long)size2 * (long)lf / (long)$this.loadFactorDenum());
        }
        throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"loadFactor too large; must be < 0.5").toString());
    }

    public static void clearTable(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq($this.loadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, FlatHashTable$class.initialCapacity($this)));
    }
}

