/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UniformGrid {
    LinkedList<Integer>[][] grid;
    LinkedList<Integer>[] cellOfNode;
    double left;
    double right;
    double top;
    double bottom;
    double cellW;
    int w;
    int h;

    UniformGrid(List<PlacementFrame.PlacementNode> nodesToPlace, double left, double right, double top, double bottom, double cellW) {
        this.cellOfNode = new LinkedList[nodesToPlace.size()];
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.cellW = cellW;
        this.w = Math.max((int)Math.ceil((right - left) / cellW), 1);
        this.h = Math.max((int)Math.ceil((top - bottom) / cellW), 1);
        this.grid = new LinkedList[this.w][this.h];
    }

    public int getCellX(double xPos) {
        int x = (int)((xPos - this.left) / this.cellW);
        if (x < 0) {
            x = 0;
        }
        if (x >= this.w) {
            x = this.w - 1;
        }
        return x;
    }

    public int getCellY(double yPos) {
        int y = (int)((yPos - this.bottom) / this.cellW);
        if (y < 0) {
            y = 0;
        }
        if (y >= this.h) {
            y = this.h - 1;
        }
        return y;
    }

    public LinkedList<Integer> insert(int i, double xPos, double yPos) {
        int y;
        int x = this.getCellX(xPos);
        if (this.grid[x][y = this.getCellY(yPos)] == null) {
            this.grid[x][y] = new LinkedList();
        }
        this.grid[x][y].add(i);
        this.cellOfNode[i] = this.grid[x][y];
        LinkedList<Integer> cellList = this.cellOfNode[i];
        return cellList;
    }

    public void remove(int nodeIndex) {
        LinkedList<Integer> cellList = this.cellOfNode[nodeIndex];
        if (cellList == null) {
            System.out.println("ARRAY PANIC in remove in UniformGrid");
        }
        Iterator it = cellList.iterator();
        while (it.hasNext()) {
            if ((Integer)it.next() != nodeIndex) continue;
            it.remove();
            return;
        }
    }

    public double collide(Block b, List<Block> deltas, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps) {
        double overlap = 0.0;
        int x = this.getCellX(b.getX());
        int y = this.getCellY(b.getY());
        Block orig = new Block();
        orig.valuesFrom(nodesToPlace.get(b.getNr()));
        orig.number = b.getNr();
        int oldX = this.getCellX(orig.getX());
        int oldY = this.getCellY(orig.getY());
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                overlap += this.collideCell(b, deltas, nodesToPlace, overlaps, x + i, y + j, false);
                overlap -= this.collideCell(orig, deltas, nodesToPlace, overlaps, oldX + i, oldY + j, true);
            }
        }
        return overlap;
    }

    public double collideCell(Block b, List<Block> deltas, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps, int x, int y, boolean oldBlock) {
        if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
            return 0.0;
        }
        if (this.grid[x][y] == null) {
            return 0.0;
        }
        double overlap = 0.0;
        Block other = new Block();
        Iterator<Block> iB = deltas.iterator();
        Block deltaBlock = iB.next();
        for (Integer i : this.grid[x][y]) {
            if (i.intValue() == b.getNr()) continue;
            other.valuesFrom(nodesToPlace.get(i));
            while (deltaBlock.getNr() < i && iB.hasNext()) {
                deltaBlock = iB.next();
            }
            if (deltaBlock.getNr() == i.intValue()) continue;
            overlap += b.intersectionArea(other);
            if (oldBlock) {
                int n = b.getNr();
                overlaps[n] = overlaps[n] - b.intersectionArea(other);
                continue;
            }
            int n = b.getNr();
            overlaps[n] = overlaps[n] + b.intersectionArea(other);
        }
        return overlap;
    }

    public double collide(int nodeId, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps) {
        double overlap = 0.0;
        PlacementFrame.PlacementNode n = nodesToPlace.get(nodeId);
        Block b = new Block();
        b.valuesFrom(n);
        b.number = nodeId;
        int x = this.getCellX(b.getX());
        int y = this.getCellY(b.getY());
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                overlap += this.collideCell(b, nodesToPlace, overlaps, x + i, y + j);
            }
        }
        return overlap;
    }

    public double collideCell(Block b, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps, int x, int y) {
        if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
            return 0.0;
        }
        if (this.grid[x][y] == null) {
            return 0.0;
        }
        double overlap = 0.0;
        Block other = new Block();
        for (Integer i : this.grid[x][y]) {
            if (i >= b.getNr()) {
                return overlap;
            }
            other.valuesFrom(nodesToPlace.get(i));
            overlap += b.intersectionArea(other);
            int n = b.getNr();
            overlaps[n] = overlaps[n] + b.intersectionArea(other);
        }
        return overlap;
    }

    public void draw(Graphics g, double scale) {
        for (int i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.h; ++j) {
                g.setColor(new Color((float)i / (float)this.w, (float)j / (float)this.h, 0.3f, 0.7f));
                g.drawRect((int)(this.left * scale + (double)i * this.cellW * scale), (int)(this.bottom * scale + (double)j * this.cellW * scale), (int)(this.cellW * scale), (int)(this.cellW * scale));
                g.drawString("(" + i + "," + j + ")", (int)(this.left * scale + (double)i * this.cellW * scale), (int)(this.bottom * scale + (double)j * this.cellW * scale));
            }
        }
    }
}

