/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class Signal<SS extends Sample> {
    private final String signalName;
    private final String signalContext;
    private final String fullSignalName;
    private final SignalCollection signalCollection;
    private final boolean digital;
    private final Stimuli stimuli;

    public Signal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital) {
        this.signalName = signalName;
        this.signalContext = signalContext;
        this.signalCollection = sc;
        this.fullSignalName = signalContext == null ? signalName : signalContext + (sc == null ? (char)'.' : (char)sd.getSeparatorChar()) + signalName;
        this.digital = digital;
        this.stimuli = sd;
        if (sc != null) {
            String name = TextUtils.canonicString(this.fullSignalName);
            if (name.indexOf(95) >= 0 && !name.endsWith("_")) {
                sc.addSignal(name + "_", this);
            } else {
                sc.addSignal(name, this);
            }
        }
    }

    public void clearControlPoints() {
        this.stimuli.clearControlPoints(this);
    }

    public void removeControlPoint(double time) {
        this.stimuli.removeControlPoint(this, time);
    }

    public void addControlPoint(double time) {
        this.stimuli.addControlPoint(this, time);
    }

    public Double[] getControlPoints() {
        return this.stimuli.getControlPoints(this);
    }

    public final boolean isDigital() {
        return this.digital;
    }

    public final SignalCollection getSignalCollection() {
        return this.signalCollection;
    }

    public Signal<?>[] getBusMembers() {
        return null;
    }

    public final String getSignalName() {
        return this.signalName;
    }

    public final String getSignalContext() {
        return this.signalContext;
    }

    public final String getFullName() {
        return this.fullSignalName;
    }

    public abstract View<RangeSample<SS>> getRasterView(double var1, double var3, int var5);

    public abstract View<SS> getExactView();

    public abstract double getMinTime();

    public abstract double getMaxTime();

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public abstract boolean isEmpty();

    public abstract void plot(Panel var1, Graphics var2, WaveSignal var3, Color var4, List<PolyBase> var5, Rectangle2D var6, List<Panel.WaveSelection> var7, Signal<?> var8);

    public String getBaseNameFromExtractedNet(String signalFullName) {
        String delim = this.stimuli.getNetDelimiter();
        int hashPos = signalFullName.indexOf(delim);
        return hashPos > 0 ? signalFullName.substring(0, hashPos) : signalFullName;
    }

    public static interface View<SS extends Sample> {
        public int getNumEvents();

        public double getTime(int var1);

        public SS getSample(int var1);
    }
}

