/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.IfExp;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.util.IdentityHashTable;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0;
import gnu.text.Printable;
import gnu.text.SourceLocator;
import java.io.PrintWriter;

public abstract class Expression
extends Procedure0
implements Printable,
SourceLocator {
    String filename;
    int position;
    public static final Expression[] noExpressions = new Expression[0];
    protected int flags;
    protected static final int NEXT_AVAIL_FLAG = 1;

    public final Object eval(CallContext ctx) throws Throwable {
        int start = ctx.startFromContext();
        try {
            this.match0(ctx);
            return ctx.getFromContext(start);
        }
        catch (Throwable ex) {
            ctx.cleanupFromContext(start);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object eval(Environment env) throws Throwable {
        CallContext ctx = CallContext.getInstance();
        Environment save = ctx.getEnvironmentRaw();
        if (env != save) {
            ctx.setEnvironmentRaw(env);
        }
        try {
            Object object2 = this.eval(ctx);
            return object2;
        }
        finally {
            if (env != save) {
                ctx.setEnvironmentRaw(save);
            }
        }
    }

    protected abstract boolean mustCompile();

    public final int match0(CallContext ctx) {
        ctx.proc = this;
        ctx.pc = 0;
        return 0;
    }

    public final Object apply0() throws Throwable {
        CallContext ctx = CallContext.getInstance();
        this.check0(ctx);
        return ctx.runUntilValue();
    }

    public void apply(CallContext ctx) throws Throwable {
        throw new RuntimeException("internal error - " + this.getClass() + ".eval called");
    }

    public final void print(Consumer out) {
        if (out instanceof OutPort) {
            this.print((OutPort)out);
        } else if (out instanceof PrintWriter) {
            OutPort port = new OutPort((PrintWriter)((Object)out));
            this.print(port);
            port.close();
        } else {
            CharArrayOutPort port = new CharArrayOutPort();
            this.print(port);
            port.close();
            port.writeTo(out);
        }
    }

    public abstract void print(OutPort var1);

    public void printLineColumn(OutPort out) {
        int line = this.getLineNumber();
        if (line > 0) {
            out.print("line:");
            out.print(line);
            int column = this.getColumnNumber();
            if (column > 0) {
                out.print(':');
                out.print(column);
            }
            out.writeSpaceFill();
        }
    }

    public abstract void compile(Compilation var1, Target var2);

    public final void compileWithPosition(Compilation comp, Target target) {
        int line = this.getLineNumber();
        if (line > 0) {
            comp.getCode().putLineNumber(this.getFileName(), line);
            this.compileNotePosition(comp, target, this);
        } else {
            this.compile(comp, target);
        }
    }

    public final void compileWithPosition(Compilation comp, Target target, Expression position) {
        int line = position.getLineNumber();
        if (line > 0) {
            comp.getCode().putLineNumber(position.getFileName(), line);
            this.compileNotePosition(comp, target, position);
        } else {
            this.compile(comp, target);
        }
    }

    public final void compileNotePosition(Compilation comp, Target target, Expression position) {
        String saveFilename = comp.getFileName();
        int saveLine = comp.getLineNumber();
        int saveColumn = comp.getColumnNumber();
        comp.setLine(position);
        this.compile(comp, target);
        comp.setLine(saveFilename, saveLine, saveColumn);
    }

    public final void compile(Compilation comp, Type type) {
        this.compile(comp, StackTarget.getInstance(type));
    }

    public final void compile(Compilation comp, Declaration lhs) {
        this.compile(comp, CheckedTarget.getInstance(lhs));
    }

    public static void compileButFirst(Expression exp, Compilation comp) {
        if (exp instanceof BeginExp) {
            BeginExp bexp = (BeginExp)exp;
            int n = bexp.length;
            if (n == 0) {
                return;
            }
            Expression[] exps = bexp.exps;
            Expression.compileButFirst(exps[0], comp);
            for (int i = 1; i < n; ++i) {
                exps[i].compileWithPosition(comp, Target.Ignore);
            }
        }
    }

    public static Expression deepCopy(Expression exp, IdentityHashTable mapper) {
        if (exp == null) {
            return null;
        }
        Object tr = mapper.get(exp);
        if (tr != null) {
            return (Expression)tr;
        }
        Expression copy = exp.deepCopy(mapper);
        mapper.put(exp, copy);
        return copy;
    }

    public static Expression[] deepCopy(Expression[] exps, IdentityHashTable mapper) {
        if (exps == null) {
            return null;
        }
        int nargs = exps.length;
        Expression[] a = new Expression[nargs];
        for (int i = 0; i < nargs; ++i) {
            Expression ei = exps[i];
            Expression ai = Expression.deepCopy(ei, mapper);
            if (ai == null && ei != null) {
                return null;
            }
            a[i] = ai;
        }
        return a;
    }

    protected static Expression deepCopy(Expression exp) {
        return Expression.deepCopy(exp, new IdentityHashTable());
    }

    protected Expression deepCopy(IdentityHashTable mapper) {
        return null;
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkExpression(this);
    }

    protected void walkChildren(ExpWalker walker) {
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, Declaration decl, boolean argsInlined) {
        if (!argsInlined) {
            exp.args = walker.walkExps(exp.args, exp.args.length);
        }
        return exp;
    }

    public static Expression makeWhile(Object cond, Object body, Compilation parser) {
        Expression[] inits = new Expression[1];
        LetExp let2 = new LetExp(inits);
        String fname = "%do%loop";
        Declaration fdecl = let2.addDeclaration(fname);
        ApplyExp recurse = new ApplyExp(new ReferenceExp(fdecl), noExpressions);
        LambdaExp lexp = new LambdaExp();
        parser.push(lexp);
        lexp.body = new IfExp(parser.parse(cond), new BeginExp(parser.parse(body), recurse), QuoteExp.voidExp);
        lexp.setName(fname);
        parser.pop(lexp);
        inits[0] = lexp;
        fdecl.noteValue(lexp);
        let2.setBody(new ApplyExp(new ReferenceExp(fdecl), noExpressions));
        return let2;
    }

    public final void setLocation(SourceLocator location2) {
        this.filename = location2.getFileName();
        this.setLine(location2.getLineNumber(), location2.getColumnNumber());
    }

    public final Expression setLine(Expression old) {
        this.setLocation(old);
        return this;
    }

    public final void setFile(String filename) {
        this.filename = filename;
    }

    public final void setLine(int lineno, int colno) {
        if (lineno < 0) {
            lineno = 0;
        }
        if (colno < 0) {
            colno = 0;
        }
        this.position = (lineno << 12) + colno;
    }

    public final void setLine(int lineno) {
        this.setLine(lineno, 0);
    }

    public final String getFileName() {
        return this.filename;
    }

    public void setLine(Compilation comp) {
        int line = comp.getLineNumber();
        if (line > 0) {
            this.setFile(comp.getFileName());
            this.setLine(line, comp.getColumnNumber());
        }
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.filename;
    }

    public final int getLineNumber() {
        int line = this.position >> 12;
        return line == 0 ? -1 : line;
    }

    public final int getColumnNumber() {
        int column = this.position & 0xFFF;
        return column == 0 ? -1 : column;
    }

    public boolean isStableSourceLocation() {
        return true;
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public boolean isSingleValue() {
        return OccurrenceType.itemCountIsOne(this.getType());
    }

    public Object valueIfConstant() {
        return null;
    }

    public void setFlag(boolean setting, int flag) {
        this.flags = setting ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean side_effects() {
        return true;
    }

    public String toString() {
        String tname = this.getClass().getName();
        if (tname.startsWith("gnu.expr.")) {
            tname = tname.substring(9);
        }
        return tname + "@" + Integer.toHexString(this.hashCode());
    }
}

