/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;

public class ThisExp
extends ReferenceExp {
    Expression context;

    public ThisExp() {
        super("$this$");
    }

    public ThisExp(Expression expression) {
        super("$this$");
        this.context = expression;
    }

    public ThisExp(Declaration declaration) {
        super("$this", declaration);
    }

    public ThisExp(ClassType classType) {
        this(new Declaration((Object)"this", classType));
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitPushThis();
        target.compileFromStack(compilation, this.getType());
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkThisExp(this);
    }

    public final Type getType() {
        if (this.binding != null) {
            return this.binding.getType();
        }
        if (this.context != null && this.context instanceof ClassExp) {
            return ((ClassExp)this.context).getType();
        }
        return Type.pointer_type;
    }
}

