/*
 * Decompiled with CFR 0.152.
 */
package org.domterm;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.domterm.Backend;
import org.domterm.util.Util;
import org.domterm.util.WTDebug;

public class ProcessBackend
extends Backend {
    Process process;
    private Writer pin;
    Reader pout;
    Reader perr;
    String[] commandWithArgs;
    public static String[] defaultCommandWithArgs = new String[]{"bash", "--noediting", "-i"};

    public ProcessBackend() throws Exception {
        this(defaultCommandWithArgs);
    }

    public ProcessBackend(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            stringArray = defaultCommandWithArgs;
        }
        this.commandWithArgs = stringArray;
        this.lineEditingMode = (char)112;
    }

    @Override
    public void run(Writer writer) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(this.commandWithArgs);
        Map<String, String> map = processBuilder.environment();
        map.put("TERM", "xterm-256color");
        this.addVersionInfo("ProcessClient;err-handled");
        map.put("DOMTERM", this.getVersionInfo());
        String string = System.getProperty("user.dir");
        if (string != null) {
            map.put("TERMINFO", string + "/");
        }
        this.process = processBuilder.start();
        this.pin = new OutputStreamWriter(this.process.getOutputStream());
        this.pout = new InputStreamReader(this.process.getInputStream());
        this.perr = new InputStreamReader(this.process.getErrorStream());
        this.termWriter = writer;
        this.sendInputMode(this.lineEditingMode);
        Util.copyThread(this.pout, false, writer);
        Util.copyThread(this.perr, true, writer);
    }

    @Override
    public void processInputCharacters(String string) {
        try {
            if (this.verbosity >= 2) {
                WTDebug.println("ProcessClient.processInputCharacters: '" + WTDebug.toQuoted(string) + "'");
            }
            if (string.length() == 0) {
                return;
            }
            string = string.replaceAll("\r", "\n");
            this.pin.write(string);
            this.pin.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }
}

