/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.multimedia;

import android.graphics.ImageFormat;
import android.hardware.Camera;

public class QtCameraListener
implements Camera.ShutterCallback,
Camera.PictureCallback,
Camera.AutoFocusCallback,
Camera.PreviewCallback {
    private static final String TAG = "Qt Camera";
    private static final int BUFFER_POOL_SIZE = 2;
    private int m_cameraId = -1;
    private boolean m_notifyNewFrames = false;
    private byte[][] m_previewBuffers = null;
    private byte[] m_lastPreviewBuffer = null;
    private Camera.Size m_previewSize = null;

    private QtCameraListener(int n) {
        this.m_cameraId = n;
    }

    public void notifyNewFrames(boolean bl) {
        this.m_notifyNewFrames = bl;
    }

    public byte[] lastPreviewBuffer() {
        return this.m_lastPreviewBuffer;
    }

    public int previewWidth() {
        if (this.m_previewSize == null) {
            return -1;
        }
        return this.m_previewSize.width;
    }

    public int previewHeight() {
        if (this.m_previewSize == null) {
            return -1;
        }
        return this.m_previewSize.height;
    }

    public void setupPreviewCallback(Camera camera) {
        this.m_lastPreviewBuffer = null;
        camera.setPreviewCallbackWithBuffer(null);
        Camera.Parameters parameters = camera.getParameters();
        this.m_previewSize = parameters.getPreviewSize();
        double d = (double)ImageFormat.getBitsPerPixel((int)parameters.getPreviewFormat()) / 8.0;
        int n = (int)Math.ceil(d * (double)this.m_previewSize.width * (double)this.m_previewSize.height);
        if (this.m_previewBuffers == null || this.m_previewBuffers[0].length != n) {
            this.m_previewBuffers = new byte[2][n];
        }
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        for (byte[] byArray : this.m_previewBuffers) {
            camera.addCallbackBuffer(byArray);
        }
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        if (this.m_lastPreviewBuffer != null) {
            camera.addCallbackBuffer(this.m_lastPreviewBuffer);
        }
        this.m_lastPreviewBuffer = byArray;
        if (byArray != null && this.m_notifyNewFrames) {
            QtCameraListener.notifyNewPreviewFrame(this.m_cameraId, byArray, this.m_previewSize.width, this.m_previewSize.height);
        }
    }

    public void onShutter() {
        QtCameraListener.notifyPictureExposed(this.m_cameraId);
    }

    public void onPictureTaken(byte[] byArray, Camera camera) {
        QtCameraListener.notifyPictureCaptured(this.m_cameraId, byArray);
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        QtCameraListener.notifyAutoFocusComplete(this.m_cameraId, bl);
    }

    private static native void notifyAutoFocusComplete(int var0, boolean var1);

    private static native void notifyPictureExposed(int var0);

    private static native void notifyPictureCaptured(int var0, byte[] var1);

    private static native void notifyNewPreviewFrame(int var0, byte[] var1, int var2, int var3);
}

