/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.util.Log;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class QtBluetoothLE {
    private static final String TAG = "QtBluetoothGatt";
    private final BluetoothAdapter mBluetoothAdapter;
    private boolean mLeScanRunning = false;
    private BluetoothGatt mBluetoothGatt = null;
    private String mRemoteGattAddress;
    private final UUID clientCharacteristicUuid = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    long qtObject = 0L;
    Context qtContext = null;
    private final BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
            if (QtBluetoothLE.this.qtObject == 0L) {
                return;
            }
            QtBluetoothLE.this.leScanResult(QtBluetoothLE.this.qtObject, bluetoothDevice, n);
        }
    };
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
            int n3;
            if (QtBluetoothLE.this.qtObject == 0L) {
                return;
            }
            int n4 = 0;
            switch (n2) {
                case 0: {
                    n4 = 0;
                    QtBluetoothLE.this.resetData();
                    if (QtBluetoothLE.this.mBluetoothGatt != null) {
                        QtBluetoothLE.this.mBluetoothGatt.close();
                    }
                    QtBluetoothLE.this.mBluetoothGatt = null;
                    break;
                }
                case 2: {
                    n4 = 2;
                }
            }
            switch (n) {
                case 0: {
                    n3 = 0;
                    break;
                }
                default: {
                    Log.w((String)QtBluetoothLE.TAG, (String)("Unhandled error code on connectionStateChanged: " + n));
                    n3 = n;
                }
            }
            QtBluetoothLE.this.leConnectionStateChange(QtBluetoothLE.this.qtObject, n3, n4);
        }

        public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            switch (n) {
                case 0: {
                    n2 = 0;
                    List list = QtBluetoothLE.this.mBluetoothGatt.getServices();
                    for (BluetoothGattService bluetoothGattService : list) {
                        stringBuilder.append(bluetoothGattService.getUuid().toString()).append(" ");
                    }
                    break;
                }
                default: {
                    Log.w((String)QtBluetoothLE.TAG, (String)("Unhandled error code on onServicesDiscovered: " + n));
                    n2 = n;
                }
            }
            QtBluetoothLE.this.leServicesDiscovered(QtBluetoothLE.this.qtObject, n2, stringBuilder.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            boolean bl;
            boolean bl2 = bl = QtBluetoothLE.this.runningHandle != -1;
            if (n != 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onCharacteristicRead error: " + n));
                if (bl) {
                    return;
                }
            }
            Object object = this;
            synchronized (object) {
                if (QtBluetoothLE.this.uuidToEntry.isEmpty()) {
                    return;
                }
            }
            if (!bl) {
                int n2 = -1;
                Object object2 = this;
                synchronized (object2) {
                    n2 = QtBluetoothLE.this.handleForCharacteristic(bluetoothGattCharacteristic);
                }
                object2 = QtBluetoothLE.this.readWriteQueue;
                synchronized (object2) {
                    QtBluetoothLE.this.ioJobPending = false;
                }
                if (n2 == -1) {
                    Log.w((String)QtBluetoothLE.TAG, (String)"Out-of-detail-discovery: char update failed. Cannot find handle for characteristic");
                } else if (n == 0) {
                    QtBluetoothLE.this.leCharacteristicRead(QtBluetoothLE.this.qtObject, bluetoothGattCharacteristic.getService().getUuid().toString(), n2 + 1, bluetoothGattCharacteristic.getUuid().toString(), bluetoothGattCharacteristic.getProperties(), bluetoothGattCharacteristic.getValue());
                } else {
                    QtBluetoothLE.this.leServiceError(QtBluetoothLE.this.qtObject, n2 + 1, 5);
                }
                QtBluetoothLE.this.performNextIO();
                return;
            }
            object = (GattEntry)QtBluetoothLE.this.entries.get(QtBluetoothLE.this.runningHandle);
            ((GattEntry)object).valueKnown = true;
            QtBluetoothLE.this.entries.set(QtBluetoothLE.this.runningHandle, object);
            QtBluetoothLE.this.leCharacteristicRead(QtBluetoothLE.this.qtObject, bluetoothGattCharacteristic.getService().getUuid().toString(), QtBluetoothLE.this.runningHandle + 1, bluetoothGattCharacteristic.getUuid().toString(), bluetoothGattCharacteristic.getProperties(), bluetoothGattCharacteristic.getValue());
            QtBluetoothLE.this.performServiceDetailDiscoveryForHandle(QtBluetoothLE.this.runningHandle + 1, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            int n2;
            int n3;
            if (n != 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onCharacteristicWrite: error " + n));
            }
            if ((n3 = QtBluetoothLE.this.handleForCharacteristic(bluetoothGattCharacteristic)) == -1) {
                Log.w((String)QtBluetoothLE.TAG, (String)"onCharacteristicWrite: cannot find handle");
                return;
            }
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
            synchronized (linkedList) {
                QtBluetoothLE.this.ioJobPending = false;
            }
            QtBluetoothLE.this.leCharacteristicWritten(QtBluetoothLE.this.qtObject, n3 + 1, bluetoothGattCharacteristic.getValue(), n2);
            QtBluetoothLE.this.performNextIO();
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            int n = QtBluetoothLE.this.handleForCharacteristic(bluetoothGattCharacteristic);
            if (n == -1) {
                Log.w((String)QtBluetoothLE.TAG, (String)"onCharacteristicChanged: cannot find handle");
                return;
            }
            QtBluetoothLE.this.leCharacteristicChanged(QtBluetoothLE.this.qtObject, n + 1, bluetoothGattCharacteristic.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            byte by;
            boolean bl;
            boolean bl2 = bl = QtBluetoothLE.this.runningHandle != -1;
            if (n != 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onDescriptorRead error: " + n));
                if (bl) {
                    return;
                }
            }
            Object object = this;
            synchronized (object) {
                if (QtBluetoothLE.this.uuidToEntry.isEmpty()) {
                    return;
                }
            }
            if (!bl) {
                int n2 = -1;
                Object object2 = this;
                synchronized (object2) {
                    n2 = QtBluetoothLE.this.handleForDescriptor(bluetoothGattDescriptor);
                }
                object2 = QtBluetoothLE.this.readWriteQueue;
                synchronized (object2) {
                    QtBluetoothLE.this.ioJobPending = false;
                }
                if (n2 == -1) {
                    Log.w((String)QtBluetoothLE.TAG, (String)"Out-of-detail-discovery: char update failed. Cannot find handle for descriptor.");
                } else if (n == 0) {
                    QtBluetoothLE.this.leDescriptorRead(QtBluetoothLE.this.qtObject, bluetoothGattDescriptor.getCharacteristic().getService().getUuid().toString(), bluetoothGattDescriptor.getCharacteristic().getUuid().toString(), n2 + 1, bluetoothGattDescriptor.getUuid().toString(), bluetoothGattDescriptor.getValue());
                } else {
                    QtBluetoothLE.this.leServiceError(QtBluetoothLE.this.qtObject, n2 + 1, 6);
                }
                QtBluetoothLE.this.performNextIO();
                return;
            }
            object = (GattEntry)QtBluetoothLE.this.entries.get(QtBluetoothLE.this.runningHandle);
            ((GattEntry)object).valueKnown = true;
            QtBluetoothLE.this.entries.set(QtBluetoothLE.this.runningHandle, object);
            QtBluetoothLE.this.leDescriptorRead(QtBluetoothLE.this.qtObject, bluetoothGattDescriptor.getCharacteristic().getService().getUuid().toString(), bluetoothGattDescriptor.getCharacteristic().getUuid().toString(), QtBluetoothLE.this.runningHandle + 1, bluetoothGattDescriptor.getUuid().toString(), bluetoothGattDescriptor.getValue());
            if (bluetoothGattDescriptor.getUuid().compareTo(QtBluetoothLE.this.clientCharacteristicUuid) == 0 && ((by = bluetoothGattDescriptor.getValue()[0]) & 3) > 0) {
                Log.d((String)QtBluetoothLE.TAG, (String)"Found descriptor with automatic notifications.");
                QtBluetoothLE.this.mBluetoothGatt.setCharacteristicNotification(bluetoothGattDescriptor.getCharacteristic(), true);
            }
            QtBluetoothLE.this.performServiceDetailDiscoveryForHandle(QtBluetoothLE.this.runningHandle + 1, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            int n2;
            if (n != 0) {
                Log.w((String)QtBluetoothLE.TAG, (String)("onDescriptorWrite: error " + n));
            }
            int n3 = QtBluetoothLE.this.handleForDescriptor(bluetoothGattDescriptor);
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 3;
                }
            }
            LinkedList linkedList = QtBluetoothLE.this.readWriteQueue;
            synchronized (linkedList) {
                QtBluetoothLE.this.ioJobPending = false;
            }
            QtBluetoothLE.this.leDescriptorWritten(QtBluetoothLE.this.qtObject, n3 + 1, bluetoothGattDescriptor.getValue(), n2);
            QtBluetoothLE.this.performNextIO();
        }
    };
    private final Hashtable<UUID, List<Integer>> uuidToEntry = new Hashtable(100);
    private final ArrayList<GattEntry> entries = new ArrayList(100);
    private final LinkedList<Integer> servicesToBeDiscovered = new LinkedList();
    private final LinkedList<ReadWriteJob> readWriteQueue = new LinkedList();
    private boolean ioJobPending;
    private int currentServiceInDiscovery = -1;
    private int runningHandle = -1;

    public QtBluetoothLE() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public QtBluetoothLE(String string, Context context) {
        this();
        this.qtContext = context;
        this.mRemoteGattAddress = string;
    }

    public boolean scanForLeDevice(boolean bl) {
        if (bl == this.mLeScanRunning) {
            return true;
        }
        if (bl) {
            this.mLeScanRunning = this.mBluetoothAdapter.startLeScan(this.leScanCallback);
        } else {
            this.mBluetoothAdapter.stopLeScan(this.leScanCallback);
            this.mLeScanRunning = false;
        }
        return this.mLeScanRunning == bl;
    }

    public native void leScanResult(long var1, BluetoothDevice var3, int var4);

    public boolean connect() {
        BluetoothDevice bluetoothDevice;
        try {
            bluetoothDevice = this.mBluetoothAdapter.getRemoteDevice(this.mRemoteGattAddress);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)TAG, (String)("Remote address is not valid: " + this.mRemoteGattAddress));
            return false;
        }
        this.mBluetoothGatt = bluetoothDevice.connectGatt(this.qtContext, false, this.gattCallback);
        return this.mBluetoothGatt != null;
    }

    public void disconnect() {
        if (this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.disconnect();
    }

    public boolean discoverServices() {
        return this.mBluetoothGatt != null && this.mBluetoothGatt.discoverServices();
    }

    private int handleForCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (bluetoothGattCharacteristic == null) {
            return -1;
        }
        List<Integer> list = this.uuidToEntry.get(bluetoothGattCharacteristic.getService().getUuid());
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int n = list.get(0);
        try {
            block7: for (int i = n + 1; i < this.entries.size(); ++i) {
                GattEntry gattEntry = this.entries.get(i);
                if (gattEntry == null) continue;
                switch (gattEntry.type) {
                    case Descriptor: 
                    case CharacteristicValue: {
                        continue block7;
                    }
                    case Service: {
                        continue block7;
                    }
                    case Characteristic: {
                        if (gattEntry.characteristic != bluetoothGattCharacteristic) continue block7;
                        return i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    private int handleForDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        if (bluetoothGattDescriptor == null) {
            return -1;
        }
        List<Integer> list = this.uuidToEntry.get(bluetoothGattDescriptor.getCharacteristic().getService().getUuid());
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int n = list.get(0);
        try {
            block7: for (int i = n + 1; i < this.entries.size(); ++i) {
                GattEntry gattEntry = this.entries.get(i);
                if (gattEntry == null) continue;
                switch (gattEntry.type) {
                    case CharacteristicValue: 
                    case Characteristic: {
                        continue block7;
                    }
                    case Service: {
                        continue block7;
                    }
                    case Descriptor: {
                        if (gattEntry.descriptor != bluetoothGattDescriptor) continue block7;
                        return i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    private void populateHandles() {
        GattEntry gattEntry = null;
        List list = this.mBluetoothGatt.getServices();
        for (BluetoothGattService bluetoothGattService : list) {
            GattEntry gattEntry2 = new GattEntry();
            gattEntry2.type = GattEntryType.Service;
            gattEntry2.service = bluetoothGattService;
            this.entries.add(gattEntry);
            int n = this.entries.size() - 1;
            List<Integer> list2 = this.uuidToEntry.get(bluetoothGattService.getUuid());
            if (list2 == null) {
                list2 = new ArrayList<Integer>();
            }
            list2.add(this.entries.size() - 1);
            this.uuidToEntry.put(bluetoothGattService.getUuid(), list2);
            List list3 = bluetoothGattService.getCharacteristics();
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic : list3) {
                gattEntry = new GattEntry();
                gattEntry.type = GattEntryType.Characteristic;
                gattEntry.characteristic = bluetoothGattCharacteristic;
                this.entries.add(gattEntry);
                gattEntry = new GattEntry();
                gattEntry.type = GattEntryType.CharacteristicValue;
                this.entries.add(gattEntry);
                List list4 = bluetoothGattCharacteristic.getDescriptors();
                for (BluetoothGattDescriptor bluetoothGattDescriptor : list4) {
                    gattEntry = new GattEntry();
                    gattEntry.type = GattEntryType.Descriptor;
                    gattEntry.descriptor = bluetoothGattDescriptor;
                    this.entries.add(gattEntry);
                }
            }
            gattEntry2.endHandle = this.entries.size() - 1;
            this.entries.set(n, gattEntry2);
        }
        this.entries.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetData() {
        Object object = this;
        synchronized (object) {
            this.runningHandle = -1;
            this.currentServiceInDiscovery = -1;
            this.uuidToEntry.clear();
            this.entries.clear();
            this.servicesToBeDiscovered.clear();
        }
        object = this.readWriteQueue;
        synchronized (object) {
            this.readWriteQueue.clear();
        }
    }

    public synchronized boolean discoverServiceDetails(String string) {
        try {
            GattEntry gattEntry;
            int n;
            if (this.mBluetoothGatt == null) {
                return false;
            }
            if (this.entries.isEmpty()) {
                this.populateHandles();
            }
            try {
                UUID uUID = UUID.fromString(string);
                List<Integer> list = this.uuidToEntry.get(uUID);
                if (list == null || list.isEmpty()) {
                    Log.w((String)TAG, (String)("Unknown service uuid for current device: " + uUID.toString()));
                    return false;
                }
                n = list.get(0);
                gattEntry = this.entries.get(n);
                if (gattEntry == null) {
                    Log.w((String)TAG, (String)("Service with UUID " + uUID.toString() + " not found"));
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)TAG, (String)"Cannot parse given UUID");
                return false;
            }
            if (gattEntry.type != GattEntryType.Service) {
                Log.w((String)TAG, (String)("Given UUID is not a service UUID: " + string));
                return false;
            }
            if (this.currentServiceInDiscovery == n) {
                return true;
            }
            if (this.currentServiceInDiscovery != -1) {
                if (!gattEntry.valueKnown) {
                    this.servicesToBeDiscovered.add(n);
                    Log.w((String)TAG, (String)("Service discovery already running on another service, queueing request for " + string));
                } else {
                    Log.w((String)TAG, (String)"Service already known");
                }
                return true;
            }
            if (!gattEntry.valueKnown) {
                this.performServiceDetailDiscoveryForHandle(n, true);
            } else {
                Log.w((String)TAG, (String)"Service already discovered");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public String includedServices(String string) {
        UUID uUID;
        try {
            uUID = UUID.fromString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(uUID);
        if (bluetoothGattService == null) {
            return null;
        }
        List list = bluetoothGattService.getIncludedServices();
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (BluetoothGattService bluetoothGattService2 : list) {
            stringBuilder.append(bluetoothGattService2.getUuid().toString()).append(" ");
        }
        return stringBuilder.toString();
    }

    private void finishCurrentServiceDiscovery() {
        int n = this.currentServiceInDiscovery;
        GattEntry gattEntry = this.entries.get(this.currentServiceInDiscovery);
        gattEntry.valueKnown = true;
        this.entries.set(this.currentServiceInDiscovery, gattEntry);
        this.runningHandle = -1;
        this.currentServiceInDiscovery = -1;
        this.leServiceDetailDiscoveryFinished(this.qtObject, gattEntry.service.getUuid().toString(), n + 1, gattEntry.endHandle + 1);
        if (!this.servicesToBeDiscovered.isEmpty()) {
            try {
                int n2 = this.servicesToBeDiscovered.remove();
                this.performServiceDetailDiscoveryForHandle(n2, true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Log.w((String)TAG, (String)"Expected queued service but didn't find any");
            }
        }
    }

    private synchronized void performServiceDetailDiscoveryForHandle(int n, boolean bl) {
        try {
            GattEntry gattEntry;
            if (bl) {
                this.currentServiceInDiscovery = n++;
                this.runningHandle = n;
            } else {
                this.runningHandle = n;
            }
            try {
                gattEntry = this.entries.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Log.w((String)TAG, (String)"Last entry of last service read");
                this.finishCurrentServiceDiscovery();
                return;
            }
            switch (gattEntry.type) {
                case Characteristic: {
                    boolean bl2 = this.mBluetoothGatt.readCharacteristic(gattEntry.characteristic);
                    try {
                        if (!bl2) {
                            Log.d((String)TAG, (String)("Non-readable characteristic " + gattEntry.characteristic.getUuid() + " for service " + gattEntry.characteristic.getService().getUuid()));
                            this.leCharacteristicRead(this.qtObject, gattEntry.characteristic.getService().getUuid().toString(), n + 1, gattEntry.characteristic.getUuid().toString(), gattEntry.characteristic.getProperties(), gattEntry.characteristic.getValue());
                            this.performServiceDetailDiscoveryForHandle(this.runningHandle + 1, false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case CharacteristicValue: {
                    this.performServiceDetailDiscoveryForHandle(this.runningHandle + 1, false);
                    break;
                }
                case Descriptor: {
                    boolean bl3 = this.mBluetoothGatt.readDescriptor(gattEntry.descriptor);
                    if (!bl3) {
                        Log.d((String)TAG, (String)("Non-readable descriptor " + gattEntry.descriptor.getUuid() + " for service/char" + gattEntry.descriptor.getCharacteristic().getService().getUuid() + "/" + gattEntry.descriptor.getCharacteristic().getUuid()));
                        this.leDescriptorRead(this.qtObject, gattEntry.descriptor.getCharacteristic().getService().getUuid().toString(), gattEntry.descriptor.getCharacteristic().getUuid().toString(), n + 1, gattEntry.descriptor.getUuid().toString(), gattEntry.descriptor.getValue());
                        this.performServiceDetailDiscoveryForHandle(this.runningHandle + 1, false);
                    }
                    break;
                }
                case Service: {
                    this.finishCurrentServiceDiscovery();
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)"Invalid GATT attribute type");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCharacteristic(int n, byte[] byArray, int n2) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.newValue = byArray;
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Write;
        switch (n2) {
            case 1: {
                readWriteJob.requestedWriteType = 1;
                break;
            }
            case 2: {
                readWriteJob.requestedWriteType = 4;
                break;
            }
            default: {
                readWriteJob.requestedWriteType = 2;
            }
        }
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add characteristic write request for " + n + " to queue"));
            return false;
        }
        this.performNextIO();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDescriptor(int n, byte[] byArray) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.newValue = byArray;
        readWriteJob.entry = gattEntry;
        readWriteJob.requestedWriteType = 2;
        readWriteJob.jobType = IoJobType.Write;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add descriptor write request for " + n + " to queue"));
            return false;
        }
        this.performNextIO();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readCharacteristic(int n) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Read;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add characteristic read request for " + n + " to queue"));
            return false;
        }
        this.performNextIO();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readDescriptor(int n) {
        boolean bl;
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Read;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            bl = this.readWriteQueue.add(readWriteJob);
        }
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add descriptor read request for " + n + " to queue"));
            return false;
        }
        this.performNextIO();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performNextIO() {
        ReadWriteJob readWriteJob;
        if (this.mBluetoothGatt == null) {
            return;
        }
        boolean bl = false;
        LinkedList<ReadWriteJob> linkedList = this.readWriteQueue;
        synchronized (linkedList) {
            if (this.readWriteQueue.isEmpty() || this.ioJobPending) {
                return;
            }
            readWriteJob = this.readWriteQueue.remove();
            Log.w((String)TAG, (String)("Performing queued job " + (Object)((Object)readWriteJob.jobType)));
            bl = readWriteJob.jobType == IoJobType.Read ? this.executeReadJob(readWriteJob) : this.executeWriteJob(readWriteJob);
            if (!bl) {
                this.ioJobPending = true;
            }
        }
        if (bl) {
            boolean bl2;
            Log.w((String)TAG, (String)("Skipping: " + (Object)((Object)readWriteJob.entry.type)));
            boolean bl3 = bl2 = this.runningHandle != -1;
            if (!bl2) {
                int n = -1;
                n = readWriteJob.entry.type == GattEntryType.Characteristic ? this.handleForCharacteristic(readWriteJob.entry.characteristic) : this.handleForDescriptor(readWriteJob.entry.descriptor);
                if (n != -1) {
                    int n2 = 0;
                    n2 = readWriteJob.jobType == IoJobType.Read ? (readWriteJob.entry.type == GattEntryType.Characteristic ? 5 : 6) : (readWriteJob.entry.type == GattEntryType.Characteristic ? 2 : 3);
                    this.leServiceError(this.qtObject, n + 1, n2);
                }
            }
            this.performNextIO();
        }
    }

    private boolean executeWriteJob(ReadWriteJob readWriteJob) {
        switch (readWriteJob.entry.type) {
            case Characteristic: {
                boolean bl;
                if (readWriteJob.entry.characteristic.getWriteType() != readWriteJob.requestedWriteType) {
                    readWriteJob.entry.characteristic.setWriteType(readWriteJob.requestedWriteType);
                }
                if ((bl = readWriteJob.entry.characteristic.setValue(readWriteJob.newValue)) && this.mBluetoothGatt.writeCharacteristic(readWriteJob.entry.characteristic)) break;
                return true;
            }
            case Descriptor: {
                boolean bl;
                if (readWriteJob.entry.descriptor.getUuid().compareTo(this.clientCharacteristicUuid) == 0) {
                    boolean bl2 = false;
                    int n = readWriteJob.newValue[0] & 0xFF;
                    if ((n & 1) == 1 || (n >> 1 & 1) == 1) {
                        bl2 = true;
                    }
                    if (!(bl = this.mBluetoothGatt.setCharacteristicNotification(readWriteJob.entry.descriptor.getCharacteristic(), bl2))) {
                        Log.w((String)TAG, (String)"Cannot set characteristic notification");
                    }
                    Log.d((String)TAG, (String)("Enable notifications: " + bl2));
                }
                if ((bl = readWriteJob.entry.descriptor.setValue(readWriteJob.newValue)) && this.mBluetoothGatt.writeDescriptor(readWriteJob.entry.descriptor)) break;
                return true;
            }
            case CharacteristicValue: 
            case Service: {
                return true;
            }
        }
        return false;
    }

    private boolean executeReadJob(ReadWriteJob readWriteJob) {
        switch (readWriteJob.entry.type) {
            case Characteristic: {
                boolean bl = this.mBluetoothGatt.readCharacteristic(readWriteJob.entry.characteristic);
                if (bl) break;
                return true;
            }
            case Descriptor: {
                boolean bl = this.mBluetoothGatt.readDescriptor(readWriteJob.entry.descriptor);
                if (bl) break;
                return true;
            }
            case CharacteristicValue: 
            case Service: {
                return true;
            }
        }
        return false;
    }

    public native void leConnectionStateChange(long var1, int var3, int var4);

    public native void leServicesDiscovered(long var1, int var3, String var4);

    public native void leServiceDetailDiscoveryFinished(long var1, String var3, int var4, int var5);

    public native void leCharacteristicRead(long var1, String var3, int var4, String var5, int var6, byte[] var7);

    public native void leDescriptorRead(long var1, String var3, String var4, int var5, String var6, byte[] var7);

    public native void leCharacteristicWritten(long var1, int var3, byte[] var4, int var5);

    public native void leDescriptorWritten(long var1, int var3, byte[] var4, int var5);

    public native void leCharacteristicChanged(long var1, int var3, byte[] var4);

    public native void leServiceError(long var1, int var3, int var4);

    private class ReadWriteJob {
        public GattEntry entry;
        public byte[] newValue;
        public int requestedWriteType;
        public IoJobType jobType;

        private ReadWriteJob() {
        }
    }

    private static enum IoJobType {
        Read,
        Write;

    }

    private class GattEntry {
        public GattEntryType type;
        public boolean valueKnown = false;
        public BluetoothGattService service = null;
        public BluetoothGattCharacteristic characteristic = null;
        public BluetoothGattDescriptor descriptor = null;
        public int endHandle;

        private GattEntry() {
        }
    }

    private static enum GattEntryType {
        Service,
        Characteristic,
        CharacteristicValue,
        Descriptor;

    }
}

