/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class CacheConfiguration
implements Cloneable {
    protected String name;
    protected int maxElementsInMemory;
    protected int maxElementsOnDisk;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy;
    protected boolean eternal;
    protected long timeToIdleSeconds;
    protected long timeToLiveSeconds;
    protected boolean overflowToDisk;
    protected boolean diskPersistent;
    protected int diskSpoolBufferSizeMB;
    protected long diskExpiryThreadIntervalSeconds;
    protected final List cacheEventListenerConfigurations = new ArrayList();
    protected final List cacheExtensionConfigurations = new ArrayList();
    protected BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration;
    protected CacheExceptionHandlerFactoryConfiguration cacheExceptionHandlerFactoryConfiguration;
    protected CacheLoaderFactoryConfiguration cacheLoaderFactoryConfiguration;

    public Object clone() throws CloneNotSupportedException {
        CacheConfiguration copy = (CacheConfiguration)super.clone();
        return copy;
    }

    public final void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cache name cannot contain '/' characters.");
        }
        this.name = name;
    }

    public final void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public final void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.fromString(memoryStoreEvictionPolicy);
    }

    public final void setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public final void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public final void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public final void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public final void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public final void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public int getDiskSpoolBufferSizeMB() {
        return this.diskSpoolBufferSizeMB;
    }

    public void setDiskSpoolBufferSizeMB(int diskSpoolBufferSizeMB) {
        this.diskSpoolBufferSizeMB = diskSpoolBufferSizeMB;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public final void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public final void addCacheEventListenerFactory(CacheEventListenerFactoryConfiguration factory) {
        this.cacheEventListenerConfigurations.add(factory);
    }

    public final void addCacheExtensionFactory(CacheExtensionFactoryConfiguration factory) {
        this.cacheExtensionConfigurations.add(factory);
    }

    public final void addBootstrapCacheLoaderFactory(BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration) {
        this.bootstrapCacheLoaderFactoryConfiguration = bootstrapCacheLoaderFactoryConfiguration;
    }

    public final void addCacheExceptionHandlerFactory(CacheExceptionHandlerFactoryConfiguration cacheExceptionHandlerFactoryConfiguration) {
        this.cacheExceptionHandlerFactoryConfiguration = cacheExceptionHandlerFactoryConfiguration;
    }

    public final void addCacheLoaderFactory(CacheLoaderFactoryConfiguration cacheLoaderFactoryConfiguration) {
        this.cacheLoaderFactoryConfiguration = cacheLoaderFactoryConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public List getCacheEventListenerConfigurations() {
        return this.cacheEventListenerConfigurations;
    }

    public List getCacheExtensionConfigurations() {
        return this.cacheExtensionConfigurations;
    }

    public BootstrapCacheLoaderFactoryConfiguration getBootstrapCacheLoaderFactoryConfiguration() {
        return this.bootstrapCacheLoaderFactoryConfiguration;
    }

    public CacheExceptionHandlerFactoryConfiguration getCacheExceptionHandlerFactoryConfiguration() {
        return this.cacheExceptionHandlerFactoryConfiguration;
    }

    public CacheLoaderFactoryConfiguration getCacheLoaderFactoryConfiguration() {
        return this.cacheLoaderFactoryConfiguration;
    }

    public final class CacheLoaderFactoryConfiguration
    extends FactoryConfiguration {
    }

    public final class CacheExceptionHandlerFactoryConfiguration
    extends FactoryConfiguration {
    }

    public final class BootstrapCacheLoaderFactoryConfiguration
    extends FactoryConfiguration {
    }

    public final class CacheExtensionFactoryConfiguration
    extends FactoryConfiguration {
    }

    public final class CacheEventListenerFactoryConfiguration
    extends FactoryConfiguration {
    }
}

