/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast;

import groovy.contracts.Contracted;
import java.util.ArrayList;
import java.util.List;
import org.apache.groovy.contracts.ast.BaseASTTransformation;
import org.apache.groovy.contracts.ast.visitor.AnnotationClosureVisitor;
import org.apache.groovy.contracts.ast.visitor.ConfigurationSetup;
import org.apache.groovy.contracts.ast.visitor.ContractElementVisitor;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class ClosureExpressionEvaluationASTTransformation
extends BaseASTTransformation {
    private void generateAnnotationClosureClasses(SourceUnit unit, ReaderSource source, List<ClassNode> classNodes) {
        AnnotationClosureVisitor annotationClosureVisitor = new AnnotationClosureVisitor(unit, source);
        for (ClassNode classNode : classNodes) {
            annotationClosureVisitor.visitClass(classNode);
            if (!CandidateChecks.isContractsCandidate(classNode)) continue;
            ContractElementVisitor contractElementVisitor = new ContractElementVisitor(unit, source);
            contractElementVisitor.visitClass(classNode);
            if (!contractElementVisitor.isFoundContractElement()) continue;
            annotationClosureVisitor.visitClass(classNode);
            this.markClassNodeAsContracted(classNode);
            new ConfigurationSetup().init(classNode);
        }
    }

    public void visit(ASTNode[] nodes, SourceUnit unit) {
        ModuleNode moduleNode = unit.getAST();
        ReaderSource source = this.getReaderSource(unit);
        ArrayList<ClassNode> classNodes = new ArrayList<ClassNode>(moduleNode.getClasses());
        this.generateAnnotationClosureClasses(unit, source, classNodes);
    }

    private void markClassNodeAsContracted(ClassNode classNode) {
        ClassNode contractedAnnotationClassNode = ClassHelper.makeWithoutCaching(Contracted.class);
        if (classNode.getAnnotations(contractedAnnotationClassNode).isEmpty()) {
            classNode.addAnnotation(new AnnotationNode(contractedAnnotationClassNode));
        }
    }
}

